<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:variable name="icons_src_dir">.</xsl:variable>
	
	<xsl:template match="item">
		<div class="dhx_folders_FTILES_item">
			<!-- icon -->
			<img border='0' style="float:left;">
				<xsl:if test="./@type='dir'">
					<xsl:attribute name="src"><xsl:value-of select="$icons_src_dir"/>/ico_fldr_48.gif</xsl:attribute>
				</xsl:if>
				<xsl:if test="./@type!='dir'">
					<xsl:attribute name="src"><xsl:value-of select="$icons_src_dir"/>/ico_<xsl:value-of select="substring-after(./@name,'.')"/>_48.gif</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="onerror">this.onerror = null;this.src='<xsl:value-of select="$icons_src_dir"/>/ico_unknown_48.gif';</xsl:attribute>
			</img>
			<!-- label -->
			<div class="dhx_folders_FTILES_item_text" style="margin-top:10px;">
				<xsl:if test="./@type='dir'">
					<xsl:value-of select="./@name"/>
				</xsl:if>
				<xsl:if test="./@type!='dir'">
					<xsl:value-of select="substring-before(./@name,'.')"/>
				</xsl:if>
			</div>
			<!-- file size -->
			<div class="dhx_folders_FTILES_item_text_gray">
				<xsl:if test="./@type='dir'">
						Directory 
				</xsl:if>
				<xsl:if test="./@type!='dir'">
					<xsl:value-of select="./filesize"/>b
				</xsl:if>
			</div>
		</div>
	</xsl:template>
	
</xsl:stylesheet>